////  BiliOAuth.h
//  bilianime
//
//  Created by body on 2020/3/9.
//  Copyright © 2019 Bilibili. All rights reserved.
//

#import <Foundation/Foundation.h>

//! Project version number for BiliOAuth.
FOUNDATION_EXPORT double BiliOAuthVersionNumber;

//! Project version string for BiliOAuth.
FOUNDATION_EXPORT const unsigned char BiliOAuthVersionString[];

// In this header, you should import all the public headers of your framework using statements like #import <BiliOAuth/PublicHeader.h>
#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@class BiliOAuthAuthorizeResult;
@protocol BiliOAuthDelegate;

@interface BiliOAuth : NSObject

+ (BOOL)registerClient:(NSString *)clientId universalLink:(nullable NSString *)universalLink;

+ (BOOL)handleOpenURL:(NSURL *)url delegate:(nullable id<BiliOAuthDelegate>)delegate;

+ (BOOL)handleUserActivity:(NSUserActivity *)userActivity delegate:(nullable id<BiliOAuthDelegate>)delegate;

+ (void)authorize;

@end

@protocol BiliOAuthDelegate <NSObject>

- (void)didAuthorize:(BiliOAuthAuthorizeResult *)result;

@end

typedef NS_ENUM(NSUInteger, BiliOAuthAuthorizeScene) {
    BiliOAuthAuthorizeSceneClient,
    BiliOAuthAuthorizeSceneWebpage,
};

typedef NS_ENUM(NSUInteger, BiliOAuthAuthorizeState) {
    BiliOAuthAuthorizeStateSucceeded,
    BiliOAuthAuthorizeStateFailed,
    BiliOAuthAuthorizeStateCancelled,
};

@interface BiliOAuthAuthorizeResult : NSObject

@property (nonatomic, assign, readonly) BiliOAuthAuthorizeScene scene;

@property (nullable, nonatomic, copy, readonly) NSString *code;

@property (nonatomic, assign, readonly) BiliOAuthAuthorizeState state;

@end

NS_ASSUME_NONNULL_END
